## -*-Tcl-*-
 # ###################################################################
 #  HTML mode - tools for editing HTML documents
 # 
 #  FILE: "htmlEntities.tcl"
 #                                    created: 98-02-15 18.04.08 
 #                                last update: 11/7/1999 {12:51:30 pm} 
 #  Author: Johan Linde
 #  E-mail: <jlinde@telia.com>
 #     www: <http://www.theophys.kth.se/~jl/Alpha.html>
 #  
 # Version: 2.1.4
 # 
 # Copyright 1996-1999 by Johan Linde
 #  
 # This software may be used freely, and distributed freely, as long as the 
 # receiver is not obligated in any way by receiving it.
 #  
 # If you make improvements to this file, please share them!
 # 
 # ###################################################################
 ##

#===============================================================================
# Character entities
#===============================================================================

proc htmlEntities.tcl {} {}

proc htmlAddCommonChars {} {
	global modifiedModeVars HTMLmodeVars htmlSmallCharsMenu htmlCapitalCharsMenu
	global htmlOtherChars1Menu htmlOtherChars2Menu
	set commonChars $HTMLmodeVars(commonChars)

	if {![catch {listpick -l -p "Select chars for the commonly used char list" \
				[concat $htmlSmallCharsMenu $htmlCapitalCharsMenu $htmlOtherChars1Menu $htmlOtherChars2Menu]} newchars]} {
		set dirty 0
		foreach c $newchars {
			if {[lsearch -exact $commonChars $c] < 0} {
				set dirty 1
				set commonChars [lsort [lappend commonChars $c]]
			}
		}
		if {$dirty} {
			lappend modifiedModeVars {commonChars HTMLmodeVars}
			set HTMLmodeVars(commonChars) $commonChars
			htmlRebuildMenu "Rebuiding HTML menu"
			message "New characters added to the common list."
		}
	}
}

proc htmlDefaultCommonChars {} {
	global modifiedModeVars HTMLmodeVars
	
	if {[askyesno "Revert to default common characters?"] == "yes"} {
		set HTMLmodeVars(commonChars) $HTMLmodeVars(defaultCommonChars)
		lappend modifiedModeVars {commonChars HTMLmodeVars}
		htmlRebuildMenu "Rebuiding HTML menu"
		message "Common character list reverted to default."
	}	
}

proc htmlClearCommonChars {} {
	global modifiedModeVars HTMLmodeVars
	
	if {[askyesno "Remove all common characters?"] == "yes"} {
		set HTMLmodeVars(commonChars) {}
		lappend modifiedModeVars {commonChars HTMLmodeVars}
		htmlRebuildMenu "Rebuiding HTML menu"
		message "Common character list cleared."
	}	
}

#
# Insert special character entity
#
proc htmlInsertCharacter {char} {
	global htmlSpecialCharacter htmlCapCharSpecMenu htmlSpecialSymbCharacter
	if {[isSelection]} { deleteSelection }
	foreach c [list SpecialCharacter CapCharSpecMenu SpecialSymbCharacter] {
		if {[info exists html${c}($char)]} {
			insertText &[set html${c}($char)]\;
		}
	}
}


proc htmlSetEntityKeys {meny} {
	global htmlSmallCharsMenu htmlCapitalCharsMenu htmlOtherChars1Menu htmlOtherChars2Menu PREFS
	if {[file exists "$PREFS:HTML:HTML entity keys"]} {source "$PREFS:HTML:HTML entity keys"}
	foreach key [set html[join $meny ""]Menu] {
		if {[string index $key 0] == "!"} {set key [string range $key 2 end]}
		if {[info exists htmlEntityKeys($key)]} {
			lappend keys [list $htmlEntityKeys($key) $key]
		} else {
			lappend keys [list {} $key]
		}
	}
	bind::fromArray htmlEntityKeys htmlEntityKeysProc 1 HTML
	if {[eval dialog::adjustBindings [list $meny] newkeys modified 0 $keys] != "Cancel"} {
		foreach key $modified {
			if {$newkeys($key) == ""} {unset htmlEntityKeys($key) htmlEntityKeysProc($key); continue}
			set htmlEntityKeys($key) $newkeys($key)
			set htmlEntityKeysProc($key) [list htmlInsertCharacter $key]
		}
	}
	bind::fromArray htmlEntityKeys htmlEntityKeysProc 0 HTML
	htmlSaveCache "HTML entity keys" "array set htmlEntityKeys [list [array get htmlEntityKeys]]\rarray set htmlEntityKeysProc [list [array get htmlEntityKeysProc]]"
}



proc htmlNewCharVar {var val} {
	global htmlSpecialCharacter htmlCharacterSpecial
	set htmlSpecialCharacter($var) $val 
	set htmlCharacterSpecial($val) $var
}

proc htmlNewCapCharVar {var men val} {
	global htmlSpecialCapCharacter htmlCapCharacterSpecial htmlCapCharSpecMenu
	set htmlSpecialCapCharacter($var) $val 
	set htmlCapCharacterSpecial($val) $var
	set htmlCapCharSpecMenu($men) $val
}

set htmlSmallCharsMenu {eth thorn                 
           y }

htmlNewCharVar "" szlig
htmlNewCharVar "" agrave
htmlNewCharVar "" aacute
htmlNewCharVar "" acirc
htmlNewCharVar "" atilde
htmlNewCharVar "" auml
htmlNewCharVar "" aring
htmlNewCharVar "" aelig
htmlNewCharVar "" ccedil
htmlNewCharVar "" egrave
htmlNewCharVar "" eacute
htmlNewCharVar "" ecirc
htmlNewCharVar "" euml
htmlNewCharVar "" igrave
htmlNewCharVar "" iacute
htmlNewCharVar "" icirc
htmlNewCharVar "" iuml
htmlNewCharVar	"eth" eth
htmlNewCharVar "" ntilde
htmlNewCharVar "" ograve
htmlNewCharVar "" oacute
htmlNewCharVar "" ocirc
htmlNewCharVar "" otilde
htmlNewCharVar "" ouml
htmlNewCharVar "" oslash
htmlNewCharVar "" ugrave
htmlNewCharVar "" uacute
htmlNewCharVar "" ucirc
htmlNewCharVar ""	uuml
htmlNewCharVar "y" yacute
htmlNewCharVar "thorn" thorn
htmlNewCharVar ""	yuml
htmlNewCharVar "" "#339"

set htmlCapitalCharsMenu {ETH THORN  A A^      E`  E^ E I` I I^ I 
O` O O^     U` U U^  Y Y}

htmlNewCapCharVar "" "" Agrave
htmlNewCapCharVar "" "A" Aacute
htmlNewCapCharVar "" "A^" Acirc
htmlNewCapCharVar "" "" Atilde
htmlNewCapCharVar "" "" Auml
htmlNewCapCharVar "" "" Aring
htmlNewCapCharVar "" "" AElig
htmlNewCapCharVar "" "" Ccedil
htmlNewCapCharVar "" "E`" Egrave
htmlNewCapCharVar "" "" Eacute
htmlNewCapCharVar "" "E^" Ecirc
htmlNewCapCharVar "" "E" Euml
htmlNewCapCharVar "" "I`" Igrave
htmlNewCapCharVar "" "I" Iacute
htmlNewCapCharVar "" "I^" Icirc
htmlNewCapCharVar "" "I" Iuml
htmlNewCapCharVar "ETH" "ETH" ETH
htmlNewCapCharVar "" "" Ntilde
htmlNewCapCharVar "" "O`" Ograve
htmlNewCapCharVar "" "O" Oacute
htmlNewCapCharVar "" "O^" Ocirc
htmlNewCapCharVar "" "" Otilde
htmlNewCapCharVar "" "" Ouml
htmlNewCapCharVar "" "" Oslash
htmlNewCapCharVar "" "U`" Ugrave
htmlNewCapCharVar "" "U" Uacute
htmlNewCapCharVar "" "U^" Ucirc
htmlNewCapCharVar "" ""	Uuml
htmlNewCapCharVar "Y" "Y" Yacute
htmlNewCapCharVar "THORN" "THORN" THORN
htmlNewCapCharVar "" "" "#338"
htmlNewCapCharVar "" "Y" "#376"

set htmlSpecialSymbCharacter([list quotation mark])	quot
set htmlSpecialSymbCharacter(ampersand) amp
set htmlSpecialSymbCharacter([list less than]) lt
set htmlSpecialSymbCharacter([list greater than]) gt
set htmlSpecialSymbCharacter([list nonbreak space])	nbsp
set htmlSpecialSymbCharacter([list inverted excl. mark])	"#161"
set htmlSpecialSymbCharacter(cent) "#162"
set htmlSpecialSymbCharacter(pound)	"#163"
set htmlSpecialSymbCharacter(currency)	"#164"
set htmlSpecialSymbCharacter(yen)	"#165"
set htmlSpecialSymbCharacter([list broken bar]) "#166"
set htmlSpecialSymbCharacter([list section sign]) "#167"
set htmlSpecialSymbCharacter(diearesis) "#168"
set htmlSpecialSymbCharacter([list copyright sign])	copy
set htmlSpecialSymbCharacter([list feminine ordinal ind.])	"#170"
set htmlSpecialSymbCharacter([list left double angle])	"#171"
set htmlSpecialSymbCharacter([list not sign])	"#172"
set htmlSpecialSymbCharacter([list soft hyphen]) "#173"
set htmlSpecialSymbCharacter([list registered sign])	reg
set htmlSpecialSymbCharacter(macron)	"#175"
set htmlSpecialSymbCharacter(degree)	"#176"
set htmlSpecialSymbCharacter(plus-minus) "#177"
set htmlSpecialSymbCharacter([list superscript two]) "#178"
set htmlSpecialSymbCharacter([list superscript three]) "#179"
set htmlSpecialSymbCharacter([list acute accent]) "#180"
set htmlSpecialSymbCharacter([list micro sign])	"#181"
set htmlSpecialSymbCharacter([list paragraph sign])	"#182"
set htmlSpecialSymbCharacter([list middle dot]) "#183"
set htmlSpecialSymbCharacter(cedilla) "#184"
set htmlSpecialSymbCharacter([list superscript one]) "#185"
set htmlSpecialSymbCharacter([list maculine ordinal ind.]) "#186"
set htmlSpecialSymbCharacter([list right double angle]) "#187"
set htmlSpecialSymbCharacter([list one quarter]) "#188"
set htmlSpecialSymbCharacter([list one half]) "#189"
set htmlSpecialSymbCharacter([list three quarters]) "#190"
set htmlSpecialSymbCharacter([list inverted question mark])	"#191"
set htmlSpecialSymbCharacter(times)	"#215"
set htmlSpecialSymbCharacter(divide)	"#247"
set htmlSpecialSymbCharacter([list en dash]) "#8211"
set htmlSpecialSymbCharacter([list em dash]) "#8212"
set htmlSpecialSymbCharacter([list left single quotation]) "#8216"
set htmlSpecialSymbCharacter([list right single quotation]) "#8217"
set htmlSpecialSymbCharacter([list single low quotation]) "#8218"
set htmlSpecialSymbCharacter([list left double quotation]) "#8220"
set htmlSpecialSymbCharacter([list right double quotation]) "#8221"
set htmlSpecialSymbCharacter([list double low quotation]) "#8222"
set htmlSpecialSymbCharacter(dagger) "#8224"
set htmlSpecialSymbCharacter([list double dagger]) "#8225"
set htmlSpecialSymbCharacter([list per mille sign]) "#8240"
set htmlSpecialSymbCharacter([list left single angle]) "#8249"
set htmlSpecialSymbCharacter([list right single angle]) "#8250"
set htmlSpecialSymbCharacter(florin) "#402"
set htmlSpecialSymbCharacter(bullet) "#8226"
set htmlSpecialSymbCharacter(ellipsis) "#8230"
set htmlSpecialSymbCharacter([list trade mark sign]) "#8482"
set htmlSpecialSymbCharacter([list square root]) "#8730"
set htmlSpecialSymbCharacter(infinity) "#8734"
set htmlSpecialSymbCharacter(integral) "#8747"
set htmlSpecialSymbCharacter([list approximately equal to]) "#8776"
set htmlSpecialSymbCharacter([list not equal to]) "#8800"
set htmlSpecialSymbCharacter([list less-than or equal]) "#8804"
set htmlSpecialSymbCharacter([list greater-than or equal]) "#8805"

set htmlOtherChars1Menu {ampersand {greater than} {less than} {!less-than or equal} {!greater-than or equal}
{!approximately equal to} {!not equal to} {nonbreak space} {quotation mark} {!left double quotation}
{!right double quotation} {!left single quotation} {!right single quotation} {!single low quotation}
{!double low quotation} {!left double angle} {!right double angle} {!left single angle}
{!right single angle} {!inverted question mark} {!inverted excl. mark} {!feminine ordinal ind.}
{!maculine ordinal ind.} {superscript one} {superscript two} {superscript three} {!registered sign}
{!copyright sign} {!trade mark sign} !degree {!|broken bar}}
set htmlOtherChars2Menu {!currency !cent !pound !yen !florin {!acute accent} !diearesis !cedilla
{!section sign} {!paragraph sign} {soft hyphen} {!en dash} {!em dash} {one half} {one quarter}
{three quarters} {!per mille sign} !ellipsis !macron {!middle dot} !bullet !dagger {!double dagger}
{!micro sign} {!not sign} !plus-minus !divide times {!square root} !infinity !integral}


rename htmlNewCharVar ""
rename htmlNewCapCharVar ""
